package race.operations;

import java.util.ArrayList;
import java.util.List;

import race.Operation;

/**
 * This implementation of {@link Operation} interface executes a one-element
 * increase of a {@link List} istance. Since no particular implementation is
 * provided for toString() in {@link List} concrete classes this operation must
 * be initialized with a proper name (String) that represents the class
 * 
 * @author simone
 * @version 1.2
 * @see Operation
 *
 */
public class ListAdder implements Operation {

	private List<Integer> list;
	private String operationName;
	private Integer[] data;

	/**
	 * Create a new operation
	 * 
	 * @param list
	 *            : the concrete implementation of {@link List} that will be
	 *            used to execute this operation
	 * @param operationName
	 *            : a string representing this operation
	 */
	public ListAdder(List<Integer> list, String operationName) {
		super();
		this.list = list;
		this.operationName = operationName;
	}

	@Override
	/*
	 * (non-Javadoc)
	 * 
	 * @see contest.Operation#operate(java.util.ArrayList)
	 */
	public void operate() {
		for (int i = 0; i < data.length; i++) {
			list.add(data[i]);
		}
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return operationName+" [executed over "+data.length+" elements]";
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see contest.Operation#initializeOperationData(java.util.ArrayList)
	 */
	public void initializeOperationData(ArrayList<Integer> randomSeem) {
		this.data = new Integer[randomSeem.size()];
		for (int i = 0; i < data.length; i++) {
			data[i] = randomSeem.get(i);
		}
	}

}
